@ECHO ********** PositiveGrid Support Tool V0.4.10 **********
@ECHO OFF
SET TARGET_DIR=%~dp0

REM Spinner
@ECHO > util\spinner.txt
@start /b util\spinner.bat

REM Cleaning old data
DEL *-*-*-*-*.zip 2>nul
DEL sysinfo.txt 2>nul

REM Generating UUID
cscript //NoLogo .\util\myuuid.vbs > myuuid.txt
SET /P UPLOAD_UUID=< myuuid.txt

REM Getting user document folder
FOR /F "tokens=3" %%G in ('Reg Query "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" ^| findstr "Personal"') DO SET USER_DOC_FOLDER=%%G

REM Collecting Data
FOR /D %%G in ("%USER_DOC_FOLDER%\BIAS*") DO XCOPY "%%G" "Windows\%%~PG\%%~nG" /s /i /y /q >nul
FOR /D %%G in ("%APPDATA%\BIAS*") DO XCOPY "%%G" "Windows\%%~PG\%%~nG" /s /i /y /q >nul
FOR %%G in ("%USER_DOC_FOLDER%\PositiveGrid") DO XCOPY "%%G" "Windows\%%~PG\%%~nG" /s /i /y /q >nul
FOR %%G in ("%APPDATA%\PositiveGrid") DO XCOPY "%%G" "Windows\%%~PG\%%~nG" /s /i /y /q >nul

REM Collecting crash report
XCOPY "%LOCALAPPDATA%\CrashDumps" "Windows\CrashDumps" /s /i /y /q >nul

REM ZIP Data
FOR /D %%G in ("Windows\*") DO (
    .\util\7z.exe a -sdel -tzip %UPLOAD_UUID%.zip -ir!"%%G" >nul    
)

REM Remove Data
RD /S /Q Windows

REM Generating and adding system info
systeminfo > sysinfo.txt
WMIC path Win32_VideoController >> sysinfo.txt
reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Cryptography" >> sysinfo.txt
.\util\7z.exe a -tzip %UPLOAD_UUID%.zip sysinfo.txt >nul

REM Cleaning temporary data
DEL myuuid.txt 2>nul
DEL sysinfo.txt 2>nul
DEL util\spinner.txt 2>nul

REM Displaying message to user
SETLOCAL EnableDelayedExpansion
for /F "tokens=1,2 delims=#" %%a in ('"prompt #$H#$E# & echo on & for %%b in (1) do rem"') do (    
    set "DEL=%%a"
)

cls
ECHO/
call :ColorText 0f "Please Send"
call :ColorText 0C " %UPLOAD_UUID%.zip"
call :ColorText 0f " to PositiveGrid for analysis."
ECHO/

GOTO :Beginoffile

:ColorText
echo off
<nul set /p ".=%DEL%" > "%~2"
findstr /v /a:%1 /R "^$" "%~2" nul
del "%~2" > nul 2>&1
GOTO :eof

:Beginoffile

PAUSE